/*
 * Decompiled with CFR 0.152.
 */
import be.uclouvain.orthanc.Callbacks;
import be.uclouvain.orthanc.ChangeType;
import be.uclouvain.orthanc.ResourceType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.HardcodedServerAddressStrategy;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletException;
import org.springframework.mock.web.MockServletConfig;

public class Main
extends RestfulServer {
    private static Main main = new Main();

    Main() {
        this.setFhirContext(FhirContext.forR5());
        this.setServerName("Orthanc FHIR server");
        try (InputStream is2 = Main.class.getResourceAsStream("app.properties");){
            Properties properties = new Properties();
            properties.load(is2);
            this.setServerVersion(properties.getProperty("orthanc_java.version"));
        }
        catch (IOException is2) {
            // empty catch block
        }
        FhirConfiguration configuration = new FhirConfiguration();
        this.setServerAddressStrategy(new HardcodedServerAddressStrategy(configuration.getServerBaseUrl()));
        configuration.getDicomWebBaseUrl();
        OrthancPluginConnection connection = new OrthancPluginConnection();
        ArrayList<IResourceProvider> resourceProviders = new ArrayList<IResourceProvider>();
        resourceProviders.add(new PatientProvider(connection));
        resourceProviders.add(new ImagingStudyProvider(connection));
        resourceProviders.add(new EndpointProvider(connection));
        this.setResourceProviders(resourceProviders);
    }

    static {
        try {
            main.init(new MockServletConfig());
        }
        catch (ServletException e) {
            throw new RuntimeException("Cannot start the HAPI FHIR server");
        }
        Callbacks.register((Callbacks.OnChange)new Callbacks.OnChange(){

            public void call(ChangeType changeType, ResourceType resourceType, String resourceId) {
                if (changeType == ChangeType.ORTHANC_STOPPED) {
                    main.destroy();
                }
            }
        });
        Callbacks.register((String)"/fhir(/.*)", (Callbacks.OnRestRequest)new FhirRequestHandler(main));
        Callbacks.register((String)"/fhir", (Callbacks.OnRestRequest)new FhirRequestHandler(main));
    }
}

