/*
 * Decompiled with CFR 0.152.
 */
import be.uclouvain.orthanc.ResourceType;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.ImagingStudy;

public class ImagingStudyProvider
implements IResourceProvider {
    private IOrthancConnection orthanc;

    ImagingStudyProvider(IOrthancConnection orthanc) {
        this.orthanc = orthanc;
    }

    public Class<ImagingStudy> getResourceType() {
        return ImagingStudy.class;
    }

    @Read
    public ImagingStudy getResourceById(@IdParam IdType theId) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(Toolbox.TAG_STUDY_INSTANCE_UID, theId.getIdPart());
        List<OrthancResource> resources = OrthancResource.find(this.orthanc, ResourceType.STUDY, tags, true);
        if (resources.size() == 0) {
            return null;
        }
        if (resources.size() > 1) {
            throw new RuntimeException("Too many matching resources");
        }
        return resources.get(0).getFhirStudy(this.orthanc);
    }

    @Search
    public List<ImagingStudy> getImagingStudies(@OptionalParam(name="identifier") StringParam theIdentifier, @OptionalParam(name="subject") ReferenceParam theSubject, @Offset Integer theOffset, @Count Integer theCount) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (theIdentifier != null) {
            tags.put(Toolbox.TAG_STUDY_INSTANCE_UID, theIdentifier.getValue());
        }
        if (theSubject != null) {
            tags.put(Toolbox.TAG_PATIENT_ID, theSubject.getValue());
        }
        boolean caseSensitive = false;
        List<OrthancResource> resources = theOffset != null && theCount != null ? OrthancResource.find(this.orthanc, ResourceType.STUDY, tags, false, theOffset, theCount) : (theCount != null ? OrthancResource.find(this.orthanc, ResourceType.STUDY, tags, false, 0, theCount) : OrthancResource.find(this.orthanc, ResourceType.STUDY, tags, false));
        ArrayList<ImagingStudy> studies = new ArrayList<ImagingStudy>();
        for (OrthancResource resource : resources) {
            ImagingStudy study = resource.getFhirStudy(this.orthanc);
            if (!study.hasId()) continue;
            studies.add(study);
        }
        return studies;
    }
}

