/*
 * Decompiled with CFR 0.152.
 */
import be.uclouvain.orthanc.Callbacks;
import be.uclouvain.orthanc.HttpMethod;
import be.uclouvain.orthanc.RestOutput;
import ca.uhn.fhir.rest.server.RestfulServer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FhirRequestHandler
implements Callbacks.OnRestRequest {
    private static RestfulServer server;

    FhirRequestHandler(RestfulServer server) {
        FhirRequestHandler.server = server;
    }

    public void call(RestOutput output, HttpMethod method, String uri, String[] regularExpressionGroups, Map<String, String> headers, Map<String, String> getParameters, byte[] body2) {
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        if (regularExpressionGroups.length == 0) {
            request2.setRequestURI("/");
        } else {
            request2.setRequestURI(regularExpressionGroups[0]);
        }
        request2.setContent(body2);
        switch (method) {
            case GET: {
                request2.setMethod("GET");
                break;
            }
            case POST: {
                request2.setMethod("POST");
                break;
            }
            case PUT: {
                request2.setMethod("PUT");
                break;
            }
            case DELETE: {
                request2.setMethod("DELETE");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HTTP method");
            }
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request2.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : getParameters.entrySet()) {
            request2.setParameter(entry.getKey(), entry.getValue());
        }
        try {
            MockHttpServletResponse response = new MockHttpServletResponse();
            server.service((ServletRequest)request2, (ServletResponse)response);
            for (String header : response.getHeaderNames()) {
                if (header == "Content-Type") continue;
                output.setHttpHeader(header, response.getHeader(header));
            }
            output.answerBuffer(response.getContentAsByteArray(), response.getContentType());
        }
        catch (IOException e) {
            output.sendHttpStatusCode((short)500);
        }
        catch (ServletException e) {
            output.sendHttpStatusCode((short)500);
        }
    }
}

