/*
 * Decompiled with CFR 0.152.
 */
import be.uclouvain.orthanc.Functions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.json.JSONObject;

public class FhirConfiguration {
    private static final String KEY_FHIR = "FHIR";
    private static final String KEY_DICOM_WEB = "DicomWeb";
    private static final String KEY_ROOT = "Root";
    private static final String KEY_BASE_URL = "BaseUrl";
    private String serverBaseUrl = "http://localhost:8042/fhir";
    private String dicomWebRelativeUri = "../dicom-web";

    FhirConfiguration() {
        JSONObject dicomWeb;
        JSONObject fhir;
        JSONObject configuration = new JSONObject(Functions.getConfiguration());
        if (configuration.has(KEY_FHIR) && (fhir = configuration.getJSONObject(KEY_FHIR)).has(KEY_BASE_URL)) {
            this.serverBaseUrl = fhir.getString(KEY_BASE_URL);
        }
        if (configuration.has(KEY_DICOM_WEB) && (dicomWeb = configuration.getJSONObject(KEY_DICOM_WEB)).has(KEY_ROOT)) {
            this.dicomWebRelativeUri = "../" + dicomWeb.getString(KEY_ROOT);
        }
        if (!this.serverBaseUrl.endsWith("/")) {
            this.serverBaseUrl = this.serverBaseUrl + "/";
        }
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public String getDicomWebBaseUrl() {
        try {
            URL url = new URL(this.serverBaseUrl);
            URI uri = new URI(url.getPath());
            return url.getProtocol() + "://" + url.getAuthority() + uri.resolve(this.dicomWebRelativeUri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Bad URL for DICOMweb: " + this.serverBaseUrl + this.dicomWebRelativeUri);
        }
    }
}

