/*
 * Decompiled with CFR 0.152.
 */
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.server.IResourceProvider;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.IdType;

public class EndpointProvider
implements IResourceProvider {
    public static final String ID = "wado-rs";
    private IOrthancConnection orthanc;
    private FhirConfiguration configuration;

    EndpointProvider(IOrthancConnection orthanc) {
        this.orthanc = orthanc;
        this.configuration = new FhirConfiguration();
    }

    private Endpoint createEndpoint() {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(this.configuration.getDicomWebBaseUrl());
        endpoint.setId(ID);
        endpoint.setStatus(Endpoint.EndpointStatus.ACTIVE);
        endpoint.addConnectionType(Toolbox.createCodeableConcept("http://terminology.hl7.org/CodeSystem/endpoint-connection-type", "dicom-wado-rs"));
        endpoint.setName("Orthanc DICOMweb server");
        return endpoint;
    }

    public Class<Endpoint> getResourceType() {
        return Endpoint.class;
    }

    @Read
    public Endpoint getResourceById(@IdParam IdType theId) {
        if (theId.getIdPart().equals(ID) && IOrthancConnection.hasPluginInstalled(this.orthanc, "dicom-web")) {
            return this.createEndpoint();
        }
        return null;
    }

    @Search
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (IOrthancConnection.hasPluginInstalled(this.orthanc, "dicom-web")) {
            endpoints.add(this.createEndpoint());
        }
        return endpoints;
    }
}

